#pragma rtGlobals=1		// Use modern global access method.
Menu "Plot&Fit"
	Submenu "SAS Utilities"
		"-"
		Submenu "Form Factors"
			"plot gaussian",plotgaussian(1,1,1)
			"Plot fractal sphere cluster",plotit(1,1,1,1)
			"plot fractal rod cluster",plotfractalrod(80,2000,100000, 2.5, 0.02,500,6.7e-6)
			"plot fractal disk cluster",plotfractaldisk()
			"Atomic form factors", FormFactorSJ(2)
		end
	end
end
function runsphere()
	setdatafolder Root:Orphanwaves
	wave qwsphere,rwsphere
	Variable FF,v,QR
	NVAR Rglobal=root:Packages:P:Radius//
	variable  R=Rglobal
	NVAR Drhosq=root:Packages:P:Drhosq//cm-4
	NVAR phi=Root:packages:P:phi
	rwsphere=SphereFormFactorDWS(qwsphere,R,Drhosq,phi)
	Variable Sv=3*phi/(R*1e-8)	//convert to cm
	variable B=2*pi*drhosq*Sv//cm-5
	B*=1e-32//cm-1 -4
	print "B = "+ Num2str(B)+"  cm-1 -4"
end

function SphereFormFactorDWS(Qvalue,R,Drhosq,phi)
	Variable, Qvalue,R,Drhosq,phi//R in , Drhosq in cm-4
	variable QR=qvalue*R
	R=R*1e-8//cm
	variable v=(4/3)*Pi*R^3
	variable FF= (3/(QR*QR*QR))*(sin(QR)-(QR*cos(QR)))	
	Return (v*phi*(1-phi)*Drhosq*FF^2)
end


Function FormFactorSJ(qmax)//, SnOverPt)  Saint John
	variable qmax//, SnOverPt
	NewDataFolder /O/S Root:FormFactor	
	make/o qwave
	qwave=P+1
	qwave =qwave*qmax/128
	duplicate/o qwave  PtFF, SnFF,TotFF	
	Ptff=IR1_Get_f0("Ce",qwave)
	Snff=IR1_Get_f0("Cr",qwave)
	//TotFF=SnOverPt
	Display Ptff vs qwave
	appendtograph Snff vs qwave
	SetAxis left 0,80
	Label left "electron units";DelayUpdate
	Label bottom "q (-1)"
	Tag/C/N=text044/TL=0 PtFF, 39,"Ce"
	Tag/C/N=text0343/TL=0 SnFF, 39,"Cr"
end

function plotgaussian(loc,scale,pts)
	variable loc,scale,pts
	//loc=1;scale=.2;pts=100
	prompt loc, "Location"
	prompt scale,"Scale"
	prompt pts, "Points"
	
	//setdatafolder Root:p
	make/d/o/n=(pts) rwave=1+p
	variable min=loc-4*scale
	variable max=loc+4*scale
	rwave =min+((max-min))*(rwave/pts)
	duplicate/o rwave,gaus,gausrandom
	gausrandom=(2/2.1755)*gaussian(rwave,loc,scale)/(rwave^2)//lorentz effect
	gaus=gaussian(rwave,loc,scale)
	display/k=1 gausrandom vs rwave
	//appendtograph gaus vs rwave
	display/k=1 gaus vs rwave
		Label bottom "\F'times new roman'\Z18Diameter (m)";DelayUpdate
	Label left "\F'times new roman'\Z18Volume Frequency";DelayUpdate
end

function gaussian(x,loc,scale)
	variable x,loc,scale
	variable out
	out=(1/(scale*sqrt(2*pi))) * exp(-(x-loc)^2/(2*scale^2))
	return out
end


function plotit(range,r0,D, pts)
	variable r0, range,D,pts
	r0=.01; range=10;D=2;pts=1000
	prompt range,"Fractal size "
	prompt D, "Fractal dimension"
	prompt pts, "Number of points"
	Prompt r0, "Monomer size "

	setdatafolder root:
	 If (!DataFolderExists("Formfactors"))
		Newdatafolder/O/S Formfactors
	endif
		setdatafolder root:Formfactors
	 If (!DataFolderExists("FractalSphere"))
		Newdatafolder/O/S Fractalsphere
	endif
	setdatafolder root:formfactors:Fractalsphere
	make/d/o/n=(pts) qwave=1+p
	variable min=log(.01/range)
	variable max=log(100/r0)
	qwave =min+((max-min))*(qwave/pts)
	qwave=10^qwave
	duplicate/o/d qwave, qR
	duplicate/o/d qwave, rwave
	qR=qwave//*range
	variable icpt = (gamma(D+1)*(range/r0)^D)^.5
	rwave=IR1T_FractalAggofSpheresFF(qwave,range,r0,D,1,1,1)//FractalDWS(qwave,range,r0,D)//	*((4/3)*pi*r0^3)^2   ///IR1_Tiexerax(qR,Range,r0,D)
	DISPLAY/K=1 rwave vs qwave
	Modifygraph log(bottom)=1
		Modifygraph log(left)=1
		Label bottom "\F'times new roman'\Z18\f01q [\S-1\M\Z18]";DelayUpdate
	Label left "\F'times new roman'\Z18\f01 Intensity \S-1";DelayUpdate
	DrawText 0.6,0.85,"Rprimary = "+num2str(r0)
	DrawText 0.04,0.22,"Rcluster = "+num2str(range)+"      I(0) = "+num2str(rwave[0])
	//variable ratio = gamma(D+1)*((range/r0)^D)*(4/3)*pi*(r0^3)
	DrawText 0.04,0.32," gamma(D+1)*vsph*(R/a)^D = "+num2str(icpt)
	DrawText 0.04,0.42,"D = "+num2str(D)
end

function plotfractalrod(rodradius, persistencelength,Rcluster, D, phi, pts,Drho)//found some bugs.  This code has problems.  Needs to be checked
	variable rodradius, persistencelength,Rcluster, D, phi,pts,Drho//  all in A
	//rodradius=80; persistencelength=2000;Rcluster=100000; D=2.5; phi=.02;pts=500
	NVAR  DrhoSAS=Root:packages:P:Drho//from SAS modeling tool in A-2	
	Drho=DrhoSAS
	prompt Rcluster,"Cluster size "
	prompt D, "Fractal dimension"
	prompt pts, "Number of points"
	Prompt rodradius, "Rodradius "
	prompt persistencelength "Persistence length "
	prompt phi, "Volume Fraction"
	prompt Drho, "Delta rho ^-2)"
	doprompt "inputpanel", D, Rcluster,persistencelength,rodradius,phi,Drho
silent 1
	setdatafolder root:
	 If (!DataFolderExists("Formfactors"))
		Newdatafolder/O/S Formfactors
	endif
		setdatafolder root:Formfactors
	 If (!DataFolderExists("FractalRod"))
		Newdatafolder/O/S Fractalrod
	endif
	setdatafolder root:formfactors:Fractalrod
	make/d/o/n=(pts) qfractalrodmodel=1+p
	variable min=log(.1/rcluster)
	variable max=log(10/rodradius)
	qfractalrodmodel =min+((max-min))*(qfractalrodmodel/pts)
	qfractalrodmodel=10^qfractalrodmodel
	
	//variable N = (Rcluster/persistencelength)^D//number  of primaries
	variable v=pi*persistencelength*rodradius^2//vol of rodlet in A^3
	variable G=phi*v*Drho^2//A^2
	//variable samplevol=N*v/phi//A^3
	//G=G/samplevol//A^-1
	G*=1e8//cm-1
	
	
	
	//variable N = (Rcluster/persistencelength)^D//number  of primaries
	//variable v=pi*persistencelength*rodradius^2//vol of 1 rodlets in A^3
	//v=IR1T_FractalAggofRrodsVol(Rcluster,Persistencelength,rodradius, D,1,1);N=1
	//variable G=phi*(1-phi)*N*v*Drho^2
	
	//G*=1e8//cm-1
	print G
	duplicate/o qfractalrodmodel,rfractalrodmodel,rfractalpart,rrodpart	
	rrodpart=G*(IR1T_UniFiedrodFF(qfractalrodmodel,rodradius,persistencelength,1,1,1,1))^2//normalized to one at low q
	rfractalpart=G*( IR1T_FractalCluster(qfractalrodmodel,Rcluster,persistencelength,D))^2//one at large q
	rfractalrodmodel =G*(gamma(D+1)*(Rcluster/persistencelength)^D)*( IR1T_FractalAggofRodsFF(qfractalrodmodel,Rcluster,persistencelength,rodradius,D,0,0))^2
	display/k=1 rfractalrodmodel vs qfractalrodmodel
	appendtograph rfractalpart vs qFractalrodmodel
	appendtograph rrodpart vs qFractalrodmodel
	duplicate/o rrodpart, rtotal
	rtotal=rfractalpart*rrodpart/G;appendtograph rtotal vs qfractalrodmodel
	ModifyGraph log=1
	Legend/C/N=text0/A=MC
	
	ModifyGraph rgb(rfractalrodmodel)=(0,0,0),rgb(rrodpart)=(1,34817,52428);DelayUpdate
ModifyGraph rgb(rtotal)=(16385,65535,41303)
	//FormatGraph(1)
end
	



function plotfractaldisk()
	setdatafolder Root:Packages:P:
	wave qSASmodel
	If(!Waveexists(qSASmodel))
		DoAlert 0, "This tool works only in conjunction with SAS Modeling tool.\r qSASmodel wave does not exist."
		abort
	endif
	
	duplicate/o qSASmodel,rFractalmodel,qFractalmodel,rfractalpart,rdiskpart
	NVAR diskthickness=Root:Packages:P:thickness
	NVAR Rcluster=Root:Packages:P:rcluster
	NVAR Persistencelength=Root:Packages:P:persist
	NVAR D=Root:Packages:P:D	
	//variable diskthickness=9.8, persistencelength=300,Rcluster=5000, D=2.2	
	rdiskpart=(IR1T_UniFieddiskFF(qSASmodel,persistencelength,diskthickness,0,0,0,0))^2
	rfractalpart=(IR1T_FractalCluster(qFractalmodel,Rcluster,persistencelength,D))^2	
	//rfractalmodel =(fractaldisk(qFractalmodel,diskthickness,persistencelength,rcluster,D,0,0))^2
	rfractalmodel = rdiskpart*rfractalpart
	display/k=1rfractalmodel vs qfractalmodel
	appendtograph rfractalpart vs qFractalmodel
	appendtograph rdiskpart vs qFractalmodel
	ModifyGraph log=1
	Legend/C/N=legend3/A=MC
	FormatGraph(1)
	string tagit="thickness = "+num2str(diskthickness)+" \rpersistence length = "+num2str(persistencelength)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)
	TextBox/C/N=texte/A=MC tagit
end






function  IR1T_UnifiedHollowSphereFF0ld(qvalue,radius,Thickness,par2,par3,par4,par5)//calculates  amplitude
        variable qvalue,radius,thickness,par2,par3,Par4,par5   
        variable B2, G2 =1,P2,Rg2,RgCO2, B1, G1,P1,Rg1
        variable rinner=radius-thickness
        Rg2=(3/5)*(radius^2)*(1-(1-Thickness/radius)^5)/(1-(1-Thickness/radius)^3)
        Rg2=sqrt(Rg2)
        B2=(3/4)*Pi*G2*Thickness/(Radius^3-Rinner^3)
        P2=2
        
        Rg1= thickness////sqrt(3)*Radius/2
        
        RgCO2=Rg1
        B2=(3/4)*pi*G2*thickness/(radius^3-Rinner^3)
        B1=(2*pi*G2/IR1T_UnifiedHollowSphereVolume(radius, Thickness,1,1,1,1))*3*(radius^2+rinner^2)/(radius^3-rinner^3)
        P1=4
        variable result = 0
        variable QstarVector=qvalue/(erf(qvalue*Rg2/sqrt(6)))^3
        result=G2*exp(-qvalue^2*Rg2^2/3)+(B2/QstarVector^P2) * exp(-RGCO2^2 * qvalue^2/3)
        QstarVector=qvalue/(erf(qvalue*Rg1/sqrt(6)))^3
        result+=B2*exp(-qvalue^2*Rg1^2/3)+(B1/QstarVector^P1)
        return result ^.5//calculates amplitude
end


function  IR1T_UnifiedHollowSphereFF(qvalue,radius,Thickness,rhoshel,rhosolv,rhocore,par5)//calculates  amplitude
        variable qvalue,radius,thickness,rhoshel,rhosolv,rhocore,par5   

        variable rcore=radius-thickness,bes,contr,vol,f2,f

	///not complete
	contr = rhocore-rhoshel
	bes =  IR1T_UnifiedSphereFF(qvalue,rcore,1,1,1,1,1)
	vol = 4*pi/3*rcore^3
	f = vol*bes*contr
	//now the shell
	contr = rhoshel-rhosolv
	bes = IR1T_UnifiedSphereFF(qvalue,rcore+thickness,1,1,1,1,1)
	vol = 4*(pi/3)*(rcore+thickness)^3
	f += vol*bes*contr	
	// normalize to particle volume and rescale from [-1] to [cm-1]
	f2 = f*f/vol//*1.0e8	

	return (f2^.5)//calculates amplitude
end


function  IR1T_UnifiedHollowSphereVolume(radius, Thickness,par2,par3,par4,par5)
	variable radius, thickness,par2,par3,par4,par5
	variable rinner=radius-thickness
	variable  v=(4/3)*pi*(radius^3-rinner^3)
	return v
end
